/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.AI.FlyingBirdTemptGoal;
import net.pavocado.exoticbirds.entity.AI.ScavengeGoal;
import net.pavocado.exoticbirds.entity.EntityAbstractFlyingBird;
import net.pavocado.exoticbirds.entity.EntityKookaburra;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public class EntityKingfisher
extends EntityAbstractFlyingBird {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY});
    private static final Item[] SCAVENGE_ITEMS = new Item[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY, Items.field_196089_aZ, Items.field_221600_aB, Items.field_222066_kO};
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/kingfisher/kingfisher_common.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/kingfisher/kingfisher_belted.png"));
    });
    private int eatTicks;

    public EntityKingfisher(EntityType<? extends EntityKingfisher> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.KINGFISHER_EGG.get()), BIRD_TEXTURES.size(), false);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_98053_h(true);
    }

    public EntityKingfisher(EntityType<? extends EntityKookaburra> type, World worldIn, ItemStack itemEggIn, int typesCountIn, boolean isGenderedIn) {
        super(type, worldIn, itemEggIn, typesCountIn, isGenderedIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FlyingBirdTemptGoal((CreatureEntity)this, 1.0, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new ScavengeGoal((CreatureEntity)this, SCAVENGE_ITEMS, itemEntity -> {
            List<Item> itemList = Arrays.asList(SCAVENGE_ITEMS);
            return !itemEntity.func_174874_s() && itemEntity.func_70089_S() && itemList.contains(itemEntity.func_92059_d().func_77973_b());
        }));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233822_e_, 1.0);
    }

    public static boolean canSpawnInBiomeStatic(String biomeName, Biome.Category category, Biome.RainType rainType, float temperature) {
        return !ExoticBirdsConfig.blacklistedBiomesKingfisher.contains(biomeName) && !ExoticBirdsConfig.blacklistedSpawningBiomes.contains(biomeName) && category == Biome.Category.RIVER && rainType == Biome.RainType.RAIN;
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsKingfisher;
    }

    @Override
    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList((Object[])BREEDING_ITEMS.func_193365_a());
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            ++this.eatTicks;
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 600) {
                    itemstack.func_190918_g(1);
                    this.eatTicks = 0;
                } else if (this.eatTicks > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
        }
        super.func_70636_d();
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return BREEDING_ITEMS.test(itemStackIn.getStack()) && this.field_70122_E;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vec3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityKingfisher func_241840_a(ServerWorld world, AgeableEntity ageable) {
        EntityKingfisher entityKingfisher = (EntityKingfisher)((EntityType)ExoticBirdsEntities.KINGFISHER.get()).func_200721_a((World)world);
        if (entityKingfisher != null) {
            entityKingfisher.setVariant(this.getChildVariant());
        }
        return entityKingfisher;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    public boolean func_175448_a(ItemStack stack) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return itemstack.func_190926_b() && BREEDING_ITEMS.test(stack) || this.eatTicks > 0 && BREEDING_ITEMS.test(stack) && !BREEDING_ITEMS.test(itemstack);
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.4f : 0.45f;
    }

    protected void func_213345_d(DamageSource p_213345_1_) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemstack.func_190926_b()) {
            this.func_199701_a_(itemstack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
        super.func_213345_d(p_213345_1_);
    }
}

